/*- ServoPositionListener - 
 * Display the details of the position change event.
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.ServoPhidget;
import com.phidgets.event.ServoPositionChangeListener;
import com.phidgets.event.ServoPositionChangeEvent;

import javax.swing.JTextField;

public class ServoPositionListener implements ServoPositionChangeListener{
    
    private JTextField positionTxt;
    /**
     * Creates a new instance of ServoPositionListener
     */
    public ServoPositionListener(JTextField positionTxt)
    {
        this.positionTxt = positionTxt;
    }

    public void servoPositionChanged(ServoPositionChangeEvent servoPositionChangeEvent)
    {
        positionTxt.setText(Double.toString(servoPositionChangeEvent.getValue()));
    }
    
}
